/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_ADAPTER_BOARD_API_
#define SPICE3_ADAPTER_BOARD_API_

#include "rlTypes.h"

RL_C_API rlResult rlAdapterBoardGetConfig(rlHandle handle, rlIOPort port, rlAdapterBoardConfig* outConfig);
RL_C_API rlResult rlAdapterBoardSetConfig(rlHandle handle, rlIOPort port, const rlAdapterBoardConfig* config);
RL_C_API rlResult rlAdapterBoardSetConfigByName(rlHandle handle, rlIOPort port, const char* name);

RL_C_API rlResult rlAdapterBoardEnable(rlHandle handle, rlIOPort port, bool enable);
RL_C_API rlResult rlAdapterBoardEnabled(rlHandle handle, rlIOPort port, bool* out);

RL_C_API rlResult rlAdapterBoardSupportsAutoConfiguration(rlHandle handle, rlIOPort port, bool* out);
// Method "rlAdapterBoardConnected" has been deprecated. Use "SupportsAutoConfiguration"rlAdapterBoardSupportsAutoConfiguration" instead.
// RL_C_API rlResult rlAdapterBoardConnected( rlHandle handle, rlIOPort port, bool* out );

RL_C_API rlResult rlAdapterBoardValid(rlHandle handle, rlIOPort port, bool* out);

RL_C_API rlResult rlAdapterBoardGetAvailableAdapterBoardNames(
    rlHandle handle, rlIOPort port, char* outBuffer, uint32_t bufferlen, uint32_t* outLen, uint32_t* outItems);
RL_C_API rlResult rlAdapterBoardGetCurrentAdapterBoardName(rlHandle handle, rlIOPort port, char* outBuffer, uint32_t bufferlen, uint32_t* outLen);

#endif // SPICE3_ADAPTERBOARD_API_
